/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Connection;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.fbdm.Score;
import ch.fgcz.proteomics.fbdm.ScoreFive;
import java.util.ArrayList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.KShortestPaths;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

public class IsotopicSetGraph {
    private static final String BLACK = "black";
    private static final String RED = "red";
    private static final String START = "start";
    private static final String END = "end";
    private double minimum = Double.MAX_VALUE;
    private DefaultDirectedWeightedGraph<IsotopicCluster, Connection> iClusterGraph = new DefaultDirectedWeightedGraph(Connection.class);

    public IsotopicSetGraph(List<IsotopicCluster> isotopicSet, PeakList peakList, double peptidMass, int chargeState, Configuration config) {
        ArrayList<IsotopicCluster> isotopicSet2 = new ArrayList<IsotopicCluster>(isotopicSet);
        this.minimum = Double.MAX_VALUE;
        isotopicSet2.add(new IsotopicCluster(START));
        this.assignStartAndOther(isotopicSet2, peakList, peptidMass, chargeState, config);
        this.assignEnd(peakList, peptidMass, chargeState, config);
    }

    public DefaultDirectedWeightedGraph<IsotopicCluster, Connection> getIsotopicClusterGraph() {
        return this.iClusterGraph;
    }

    public GraphPath<IsotopicCluster, Connection> bestPath(IsotopicCluster startCluster, IsotopicCluster endCluster) {
        KShortestPaths kPaths = new KShortestPaths(this.iClusterGraph, 999999);
        List paths = kPaths.getPaths((Object)startCluster, (Object)endCluster);
        return (GraphPath)paths.get(paths.size() - 1);
    }

    public IsotopicCluster getStart() {
        for (IsotopicCluster cluster : this.iClusterGraph.vertexSet()) {
            if (!cluster.isNull() || cluster.getStatus() != START) continue;
            return cluster;
        }
        return null;
    }

    public IsotopicCluster getEnd() {
        for (IsotopicCluster cluster : this.iClusterGraph.vertexSet()) {
            if (!cluster.isNull() || cluster.getStatus() != END) continue;
            return cluster;
        }
        return null;
    }

    public String calculateConnection(IsotopicCluster cluster1, IsotopicCluster cluster2) {
        if (cluster1.isNotNull() && cluster1.getPeak(0).getMz() < this.minimum) {
            this.minimum = cluster1.getPeak(0).getMz();
        }
        if (cluster1.getStatus() == START && cluster2.isNotNull() && cluster2.getPeak(0).getMz() == this.minimum) {
            return BLACK;
        }
        if (cluster1.isNull() || cluster2.isNull()) {
            return null;
        }
        if (cluster1.getPeak(cluster1.size() - 1).getMz() < cluster2.getPeak(0).getMz()) {
            return BLACK;
        }
        return this.calculateConnectionCompare(cluster1, cluster2);
    }

    private void connectClusters(IsotopicCluster cluster1, IsotopicCluster cluster2, String color, PeakList peakList, double peptidMass, int chargeState, Configuration config) {
        Connection connection = new Connection(color);
        this.iClusterGraph.addVertex((Object)cluster1);
        this.iClusterGraph.addVertex((Object)cluster2);
        this.iClusterGraph.addEdge((Object)cluster1, (Object)cluster2, (Object)connection);
        Score score = new Score(peptidMass, chargeState, config);
        ScoreFive scoreFive = new ScoreFive(this.iClusterGraph, config);
        double scoreSum = 0.0;
        double additionalScore = 0.0;
        if (((IsotopicCluster)this.iClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) {
            for (Peak peakX : ((IsotopicCluster)this.iClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
                for (Peak peakY : peakList.getPeakList()) {
                    double scoreResult = score.calculateAggregatedScore(peakX.getMz(), peakY.getMz(), ((IsotopicCluster)this.iClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster());
                    double scoreFiveResult = scoreFive.calculateFifthScore(connection);
                    additionalScore += 1.0E-5;
                    scoreSum += scoreResult + scoreFiveResult;
                }
            }
        }
        if (scoreSum == 0.0) {
            scoreSum = additionalScore;
        }
        this.iClusterGraph.setEdgeWeight((Object)connection, scoreSum);
    }

    private String calculateConnectionCompare(IsotopicCluster cluster1, IsotopicCluster cluster2) {
        if (cluster1.getPeak(0).getMz() < cluster2.getPeak(0).getMz()) {
            if (cluster1.size() == 2) {
                if (cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz()) {
                    return RED;
                }
                return null;
            }
            if (cluster1.size() == 3) {
                if (cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz() || cluster1.getPeak(2).getMz() == cluster2.getPeak(0).getMz()) {
                    return RED;
                }
                if (cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz() && cluster1.getPeak(2).getMz() == cluster2.getPeak(1).getMz()) {
                    return RED;
                }
                return null;
            }
        }
        return null;
    }

    private void assignStartAndOther(List<IsotopicCluster> isotopicSet, PeakList peakList, double peptidMass, int chargeState, Configuration config) {
        for (IsotopicCluster cluster1 : isotopicSet) {
            for (IsotopicCluster cluster2 : isotopicSet) {
                String color = this.calculateConnection(cluster1, cluster2);
                if (color != null && cluster1.isNull() && cluster2.isNotNull()) {
                    this.connectClusters(cluster1, cluster2, color, peakList, peptidMass, chargeState, config);
                }
                if (color == null || !cluster1.isNotNull() || !cluster2.isNotNull()) continue;
                this.connectClusters(cluster1, cluster2, color, peakList, peptidMass, chargeState, config);
            }
        }
    }

    private void assignEnd(PeakList peakList, double peptidMass, int chargeState, Configuration config) {
        ArrayList<IsotopicCluster> isotopicClusters = new ArrayList<IsotopicCluster>();
        for (IsotopicCluster cluster1 : this.iClusterGraph.vertexSet()) {
            int edgeCount = 0;
            for (IsotopicCluster cluster2 : this.iClusterGraph.vertexSet()) {
                edgeCount += this.iClusterGraph.getAllEdges((Object)cluster1, (Object)cluster2).size();
            }
            if (edgeCount != 0) continue;
            isotopicClusters.add(cluster1);
        }
        IsotopicCluster endCluster = new IsotopicCluster(END);
        for (IsotopicCluster cluster : isotopicClusters) {
            this.connectClusters(cluster, endCluster, BLACK, peakList, peptidMass, chargeState, config);
        }
    }
}

