% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSynonyms.R
\name{getSynonyms}
\alias{getSynonyms}
\title{Compile dataframe of all synonyms listed on Amphibian Species of the World}
\usage{
getSynonyms(asw_taxonomy = defrostR::asw_taxonomy, Order = NA,
  Superfamily = NA, Family = NA, Subfamily = NA, Genus = NA,
  Species = NA)
}
\arguments{
\item{asw_taxonomy}{the ASW taxonomy table obtained with getTaxonomy(). If no table is provided, by default it will use the internally stored data set. WARNING! this version of the amphibian taxonomy may be outdated}

\item{Order}{limit search to a user-specified amphibian order}

\item{Superfamily}{limit search to a user-specified amphibian superfamily}

\item{Family}{limit search to a user-specified amphibian family}

\item{Subfamily}{limit search to a user-specified amphibian subfamily}

\item{Genus}{limit search to a user-specified amphibian genus}

\item{Species}{limit search to a user-specified amphibian species}
}
\value{
returns a dataframe listing all species and their listed synonyms
}
\description{
This function looks up any listed synonyms on the ASW website (http://research.amnh.org/vz/herpetology/amphibia/index.php/). It takes a minimum of one argument: the asw_taxonomy table generated with the function getTaxonomy(). If a full search is performed, this can take quite long (looking through ~7000 species webpages for upwards of 20 000 synonyms), but additional arguments can be included to restrict searches to a specified taxonomic group.
}
\details{
Users may experience issues with umlauts that are not supported by their system language. On Mac OSX, this can be changed by running the following line of code in R:

system("defaults write org.R-project.R force.LANG en_US.UTF-8")

and then restarting the session. Read more here: https://cran.r-project.org/bin/macosx/RMacOSX-FAQ.html#Internationalization-of-the-R_002eapp
}
\examples{
#to get a full list of synonyms for all species, run:
\dontrun{asw_synonyms<-getSynonyms()}
#to get synonyms for a specific taxonomic group only:
\dontrun{breviceptid_synonyms<-getSynonyms(Family="Brevicipitidae")}
}
