#' Amphibian Species of the World Taxonomy
#'
#' Data table generated using the getTaxonomy() function. The dataset contains a full list of species listed on the Amphibian Species of the World (ASW) website along with all higher level taxonomy and the URLs for each species. A version is stored internally for the purpose of running examples, but users should be aware that this may be outdated depending both on how recently the defrostR package as well as the ASW website has been updated.
#'
#' @docType data
#' @usage asw_taxonomy
#' @format R dataset
#' @keywords datasets
#' @details dataset last updated on 12th July 2017
#' @examples
#' head(asw_taxonomy)
#' str(asw_taxonomy)
#' asw_taxonomy<-defrostR::asw_taxonomy
'asw_taxonomy'
