% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_design.R
\name{IMSPE}
\alias{IMSPE}
\alias{IMSPE.gp}
\alias{IMSPE.dgp2}
\alias{IMSPE.dgp3}
\title{Integrated Mean Square Prediction Error for Sequential Design}
\usage{
IMSPE(object, x_new, cores)

\method{IMSPE}{gp}(object, x_new = NULL, cores = 1)

\method{IMSPE}{dgp2}(object, x_new = NULL, cores = 1)

\method{IMSPE}{dgp3}(object, x_new = NULL, cores = 1)
}
\arguments{
\item{object}{object from \code{fit_one_layer}, \code{fit_two_layer}, or 
\code{fit_three_layer}}

\item{x_new}{matrix of possible input locations, if object has been run 
through \code{predict} the previously stored \code{x_new} is used}

\item{cores}{number of cores to utilize in parallel, by default no 
parallelization is used}
}
\value{
list with elements:
\itemize{
  \item \code{value}: vector of IMSPE values, indices correspond to \code{x_new}
  \item \code{time}: computation time in seconds
}
}
\description{
Acts on a "\code{gp}", "\code{dgp2}", or "\code{dgp3}" object.
    Calculates IMSPE over the input locations \code{x_new}.  Optionally 
    utilizes SNOW parallelization.  User should select the point with the 
    lowest IMSPE to add to the design.
}
\details{
All iterations in the object are used in the calculation, so samples
    should be burned-in.  Thinning the samples using \code{trim} will speed 
    up computation.  This function may be used in two ways:
    \itemize{
        \item called on an object with only MCMC iterations, in which case 
              \code{x_new} must be specified
        \item called on an object that has been predicted over, in which case
        the \code{x_new} from \code{predict} is used
    }
    SNOW parallelization reduces computation time but requires more memory storage.
}
\examples{
# See "deepgp-package" or "fit_three_layer" for an example

}
\references{
Binois, M, J Huang, RB Gramacy, and M Ludkovski. 2019. “Replication or Exploration? 
    Sequential Design for Stochastic Simulation Experiments.” \emph{Technometrics 
    61}, 7-23. Taylor & Francis. doi:10.1080/00401706.2018.1469433.
}
