% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_description.R
\name{get_description}
\alias{get_description}
\title{Scrap the DESCRIPTION file and CRAN metadata of the package}
\usage{
get_description(package, bioc = FALSE, local = FALSE, reset_cache = FALSE)
}
\arguments{
\item{package}{A \code{character}. Name of the package that is on CRAN, Bioconductor repository or locally installed.
See \code{bioc} and \code{local} arguments.}

\item{bioc}{A \code{logical} value. If \code{TRUE} the Bioconductor dependencies data will be taken from the
Bioconductor repository. For this option to work properly, \code{BiocManager} package needs to be installed.}

\item{local}{A \code{logical} value. If \code{TRUE} only data of locally installed packages will be used (without API usage).}

\item{reset_cache}{A \code{logical} value. If \code{TRUE} the cache will be cleared before obtaining the list of packages.}
}
\value{
An object of \code{package_description} class.
}
\description{
This function uses api  of \href{http://crandb.r-pkg.org}{\bold{CRAN Data Base}}
to scrap the DESCRIPTION file and CRAN metadata of the package. It caches the results to speed the computation process.
}
\examples{
library(deepdep)

description <- get_description("ggplot2")
description

\donttest{
description_local <- get_description("deepdep", local = TRUE)
description_local
}


}
