% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompr.R
\docType{package}
\name{decompr-package}
\alias{decompr-package}
\title{Global Value Chain Decomposition}
\description{
Three global value chain (GVC) decompositions are implemented. The Leontief decomposition 
derives the value added origin of exports by country and industry as in Hummels, Ishii and Yi (2001). 
The Koopman, Wang and Wei (2014) decomposition splits country-level exports into 9 value added components, 
and the Wang, Wei and Zhu (2013) decomposition splits bilateral exports into 16 value added components. 
Various GVC indicators based on these decompositions are computed in the complimentary 'gvc' package.
}
\section{Contents}{

Interface function for quick analysis

\code{\link[=decomp]{decomp()}}

Function to load ICIO table and create a 'decompr' object

\code{\link[=load_tables_vectors]{load_tables_vectors()}}

Functions to perform GVC decompositions on a 'decompr' object

\code{\link[=leontief]{leontief()}}\cr
\code{\link[=kww]{kww()}}\cr
\code{\link[=wwz]{wwz()}}

Function to obtain KWW decomposition from WWZ decomposition

\code{\link[=wwz2kww]{wwz2kww()}}

Example ICIO data

\code{\link[=leather]{data("leather")}}
}

\references{
Hummels, D., Ishii, J., & Yi, K. M. (2001). The nature and growth of vertical specialization in world trade. \emph{Journal of international Economics, 54}(1), 75-96.

Koopman, R., Wang, Z., & Wei, S. J. (2014). Tracing value-added and double counting in gross exports. \emph{American Economic Review, 104}(2), 459-94.

Wang, Zhi, Shang-Jin Wei, and Kunfu Zhu (2013). Quantifying international production sharing at the bilateral and sector levels (No. w19677). \emph{National Bureau of Economic Research}.
}
\seealso{
http://qua.st/decompr
}
\author{
Bastiaan Quast \email{bquast@gmail.com}\cr
Fei Wang\cr
Victor Kummritz\cr
Sebastian Krantz
}
