# decctools

decctools is an R package that provides easy access to energy statistics from the United Kingdom Department of Energy and Climate Change.  It currently provides access to two major data sources:
	
  * sub-national final energy consumption data at the local authority, middle super output area (MSOA), and lower super output area (LSOA) scales
	
  * fuel mix data and the associated carbon intensity of grid electricity using Elexon balancing mechanism data

You must have either [Curl](http://curl.haxx.se/) or [Wget](http://www.gnu.org/software/wget/) installed to use this package.

## Sub-national statistics

To access sub-national statistics, you will need to use one of three methods:

  * `get_LAD_data` gets the demands from Local Authority Districts.
	
  * `get_MSOA_data` gets the demands from Middle Super Output Areas
	
  * `get_LSOA_data` gets the demands from Lower Super Output Areas`
	
For all of these methods, see `?methodname` for options to select demands for only certain zones, sectors, or fuel types.  Note that not all geographies provide the same level of data; for example at the LSOA level, data are only available for domestic electricity and gas in England and Wales.

Here's an example:

    ## Gets energy data for electricity and gas use in the domestic sector in the most recent year
    df <- get_LAD_data(sector="domestic", fuel=c("electricity", "gas"))

## Grid carbon intensity

Elexon's [BM Reports](http://www.bmreports.com/bsp/bsp_home.htm) provides data on the UK's electricity market including the amount of electricity generated by different fuel types in each half-hourly period of the day.  Historic data (back to 2009-01-01) has been archived by the charity [Renewable Energy Foundation](http://www.ref.org.uk/fuel/) and decctools uses their summaries to provide the data used here.

There are two methods of interest:

  * `get_grid_mix(start, end)` gets the amount of electricity generated by different sources at half-hourly interval between two specified Dates
  
  * `get_grid_carbon(start, end)` gets the carbon intensity of grid electricity (kg CO2/kWh) between two specified Dates
  
An example:

    get_grid_carbon('2013-05-01', '2013-05-31')
