% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de_mcmc_rev.R
\name{de_mcmc}
\alias{de_mcmc}
\title{de_mcmc}
\usage{
de_mcmc(N, data, de.model, obs.model, all.params, ref.params = NULL,
  ref.inits = NULL, Tmax, data.times, cnt = 10, plot = TRUE,
  sizestep = 0.01, solver = "ode", verbose.mcmc = TRUE, verbose = FALSE,
  ...)
}
\arguments{
\item{N}{integer, number of MCMC iterations}

\item{data}{data.frame of time course observations to fit the model to. The observations must be ordered ascending by time.}

\item{de.model}{a function defining a DE model, compliant with the solvers in deSolve or PBSddesolve}

\item{obs.model}{a function defining an observation model}

\item{all.params}{debinfer_parlist containing all model, MCMC, and observation}

\item{ref.params}{an optional named vector containing a set of reference parameters, e.g. the true paramaters underlying a simulated data set}

\item{ref.inits}{an optional named vector containing a set of reference initial values, e.g. the true initial values underlying a simulated data set}

\item{Tmax}{maximum timestep for solver}

\item{data.times}{time points for which observations are available}

\item{cnt}{integer interval at which to print and possibly plot information on the current state of the MCMC chain}

\item{plot}{logical, plot traces for all parameters at the interval defined by \code{cnt}}

\item{sizestep}{timestep for solver to return values at, only used if data.times is missing}

\item{solver}{the solver to use. 1 or "ode" = deSolve::ode; 2 or "dde" = PBSddesolve::dde; 3 or "dede" = deSolve::dde}

\item{verbose.mcmc}{logical display MCMC progress messages}

\item{verbose}{logical display verbose solver output}

\item{...}{further arguments to the solver}
}
\value{
a debinfer_result object containing input parameters, data and MCMC samples
}
\description{
Bayesian inference for a deterministic DE model (with models
solved via an DE solver) with an observation model.
}

