% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MH_tree.R
\name{sample_tree_topology}
\alias{sample_tree_topology}
\title{Sample a new tree topology using Metropolis-Hastings through randomly
detaching and re-attaching subtrees}
\usage{
sample_tree_topology(
  tree_phylo4d_old,
  Sigma_by_group,
  item_membership_list,
  c,
  c_order = 1,
  tree_structure_old = NULL,
  dist_mat_old = NULL
)
}
\arguments{
\item{tree_phylo4d_old}{a phylo4d object of tree from the previous iteration}

\item{Sigma_by_group}{a vector of diffusion variances of G groups from the previous iteration}

\item{item_membership_list}{a vector of G elements, each indicating the number of
items in this group}

\item{c}{hyparameter of divergence function a(t)}

\item{c_order}{equals 1 (default) or 2 to choose divergence function}

\item{tree_structure_old}{a data.frame of tree structure from the previous iteration. Each row
contains information of an internal node, including divergence times, number of data points
traveling through the left and right branches}

\item{dist_mat_old}{a list of leaf covariance matrix from the previous iteration. The list has length
G, the number of item groups}
}
\value{
a numeric vector of G elements, each being the newly sampled variance
of the latent location of this group
}
\description{
Sample a new tree topology using Metropolis-Hastings through randomly
detaching and re-attaching subtrees
}
