% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-pnpp_experiment.R
\name{meta_var_name}
\alias{meta_var_name}
\title{Name of variable in PNPP experiment metadata}
\usage{
meta_var_name(plate, var)
}
\description{
A default PNPP experiment uses the names "positive" and "negative" for its two
non-empty clusters. If they are changed (for example, to "wildtype" and "mutant"),
then any variable in the metadata will be renamed to use these names.
\code{meta_var_name} translates a default metadata variable name to the correct one.
}
\examples{
plate <- new_plate(dir = sample_data_dir(), type = plate_types$pnpp_experiment)
negative_name(plate) <- "mutant"
meta_var_name(plate, 'num_negative_drops')
}
\seealso{
\code{\link[ddpcr]{pnpp_experiment}}
}
\keyword{internal}
