% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_fpliv.R, R/ddml_pliv.R, R/ddml_plm.R
\name{summary.ddml_fpliv}
\alias{summary.ddml_fpliv}
\alias{summary.ddml_pliv}
\alias{summary.ddml_plm}
\title{Inference Methods for Partially Linear Estimators.}
\usage{
\method{summary}{ddml_fpliv}(object, ...)

\method{summary}{ddml_pliv}(object, ...)

\method{summary}{ddml_plm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{ddml_plm}, \code{ddml_pliv}, or
\code{ddml_fpliv} as fitted by \code{\link[=ddml_plm]{ddml_plm()}}, \code{\link[=ddml_pliv]{ddml_pliv()}},
and \code{\link[=ddml_fpliv]{ddml_fpliv()}}, respectively.}

\item{...}{Additional arguments passed to \code{vcovHC} and \code{vcovCL}.
See \code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} and \code{\link[sandwich:vcovCL]{sandwich::vcovCL()}} for a complete list of
arguments.}
}
\value{
An array with inference results for each \code{ensemble_type}.
}
\description{
Inference methods for partially linear estimators. Simple
wrapper for \code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} and \code{\link[sandwich:vcovCL]{sandwich::vcovCL()}}. Default
standard errors are heteroskedasiticty-robust. If the \code{ddml}
estimator was computed using a \code{cluster_variable}, the standard
errors are also cluster-robust by default.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the partially linear model using a single base learner, ridge.
plm_fit <- ddml_plm(y, D, X,
                    learners = list(what = mdl_glmnet,
                                    args = list(alpha = 0)),
                    sample_folds = 2,
                    silent = TRUE)
summary(plm_fit)
}
\references{
Zeileis A (2004). "Econometric Computing with HC and HAC Covariance Matrix
Estimators.” Journal of Statistical Software, 11(10), 1-17.

Zeileis A (2006). “Object-Oriented Computation of Sandwich Estimators.”
Journal of Statistical Software, 16(9), 1-16.

Zeileis A, Köll S, Graham N (2020). “Various Versatile Variances: An
Object-Oriented Implementation of Clustered Covariances in R.” Journal of
Statistical Software, 95(1), 1-36.
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}}, \code{\link[sandwich:vcovCL]{sandwich::vcovCL()}}
}
