% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_ate.R, R/ddml_att.R, R/ddml_late.R
\name{summary.ddml_ate}
\alias{summary.ddml_ate}
\alias{summary.ddml_att}
\alias{summary.ddml_late}
\title{Inference Methods for Treatment Effect Estimators.}
\usage{
\method{summary}{ddml_ate}(object, ...)

\method{summary}{ddml_att}(object, ...)

\method{summary}{ddml_late}(object, ...)
}
\arguments{
\item{object}{An object of class \code{ddml_ate}, \code{ddml_att}, and
\code{ddml_late}, as fitted by \code{\link[=ddml_ate]{ddml_ate()}}, \code{\link[=ddml_att]{ddml_att()}},
and \code{\link[=ddml_late]{ddml_late()}}, respectively.}

\item{...}{Currently unused.}
}
\value{
A matrix with inference results.
}
\description{
Inference methods for treatment effect estimators. By default,
standard errors are heteroskedasiticty-robust. If the \code{ddml}
estimator was computed using a \code{cluster_variable}, the standard
errors are also cluster-robust by default.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the average treatment effect using a single base learner, ridge.
ate_fit <- ddml_ate(y, D, X,
                    learners = list(what = mdl_glmnet,
                                    args = list(alpha = 0)),
                    sample_folds = 2,
                    silent = TRUE)
summary(ate_fit)
}
