% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ddR.R, R/pdriver.R
\docType{methods}
\name{do_dmapply}
\alias{do_dmapply}
\alias{do_dmapply,ParallelddR,function-method}
\title{Backend-specific dmapply logic. This is a required override for all
backends to implement so dmapply works.}
\usage{
do_dmapply(driver, func, ..., MoreArgs = list(), output.type = "dlist",
  nparts = NULL, combine = "default")

\S4method{do_dmapply}{ParallelddR,`function`}(driver, func, ...,
  MoreArgs = list(), output.type = c("dlist", "dframe", "darray",
  "sparse_darray"), nparts = NULL, combine = c("default", "c", "rbind",
  "cbind"))
}
\arguments{
\item{driver}{The driver that the logic dispatches on.}

\item{func}{The function to execute}

\item{...}{Iterable arguments from dmapply.}

\item{MoreArgs}{A list of more arguments to the funciton.}

\item{output.type}{The type of output (can be 'dlist', 'darray',
'sparse_darray', or 'dframe').}

\item{nparts}{A 2d-vector indicating how the output is partitioned.}

\item{combine}{One of 'default', 'rbind', 'cbind', or 'c', which
specifies how the results from each partition should be combined.}
}
\value{
An object specific to the backend, with the nparts and psize
fields filled.
}
\description{
Backend-specific dmapply logic. This is a required override for all
backends to implement so dmapply works.
}

