% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod-results-boxes.R
\name{results_boxes_ui}
\alias{results_boxes_ui}
\alias{results_boxes_server}
\title{UI function for results boxes module}
\usage{
results_boxes_ui(id)

results_boxes_server(input, output, session, results)
}
\arguments{
\item{id}{The module id.}

\item{input}{The input from \code{\link[shiny:callModule]{shiny::callModule()}}.}

\item{output}{The output from \code{\link[shiny:callModule]{shiny::callModule()}}.}

\item{session}{The session from \code{\link[shiny:callModule]{shiny::callModule()}}.}

\item{results}{List of the validation results. If \code{NULL},
box titles will be default strings (i.e. "Successess (0)");
otherwise, the boxes will be populated with the
results.}
}
\value{
The html UI for the module.
}
\description{
This function outputs the html tags needed to
create UI for the successes, warnings, and
failures results boxes.

This gives functionality to the results boxes module
UI, attaching titles and populating
the validation results.
}
\examples{
library("shiny")
library("shinydashboard")

server <- function(input, output) {
  # Create some sample results
  res <- list(
    check_pass(msg = "All good!", behavior = "Values should be >10"),
    check_fail(
      msg = "Some values are too small",
      behavior = "Values should be > 10",
      data = c(5.5, 1.3)
    )
  )
  # Show results in boxes
  callModule(results_boxes_server, "Validation Results", res)
}

ui <- function(request) {
  dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    body = dashboardBody(
      includeCSS(
        system.file("app/www/custom.css", package = "dccvalidator")
      ),
      results_boxes_ui("Validation Results")
    )
  )
}
\dontrun{
shinyApp(ui, server)
}
}
