% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{dbxUpdate}
\alias{dbxUpdate}
\title{Update records}
\usage{
dbxUpdate(conn, table, records, where_cols, batch_size = NULL)
}
\arguments{
\item{conn}{A DBIConnection object}

\item{table}{The table name to update}

\item{records}{A data frame of records to insert}

\item{where_cols}{The columns to use for WHERE clause}

\item{batch_size}{The number of records to update in a single transaction (defaults to all)}
}
\description{
Update records
}
\examples{
db <- dbxConnect(adapter="sqlite", dbname=":memory:")
table <- "forecasts"
DBI::dbCreateTable(db, table, data.frame(id=1:3, temperature=20:22))

records <- data.frame(id=c(1, 2), temperature=c(16, 13))
dbxUpdate(db, table, records, where_cols=c("id"))
}
