% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-mysql.R
\name{backend-mysql}
\alias{simulate_mysql}
\title{Backend: MySQL/MariaDB}
\usage{
simulate_mysql()
}
\description{
See \code{vignette("translation-function")} and \code{vignette("translation-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item \code{paste()} uses \code{CONCAT_WS()}
\item String translations for \code{str_detect()}, \code{str_locate()}, and
\code{str_replace_all()}
\item Clear error message for unsupported full joins
}

Use \code{simulate_mysql()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_mysql())
lf \%>\% transmute(x = paste0(z, " times"))
}
