% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baci.R
\encoding{UTF-8}
\name{load_baci}
\alias{load_baci}
\title{BACI - Global international trade}
\usage{
load_baci(dataset = "HS92", raw_data = FALSE, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("HS92").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads disaggregated data on bilateral trade flows for more than 5000 products and 200 countries.
}
\examples{
\dontrun{
# download treated data for 2016 (takes a long time to download)
clean_baci <- load_baci(
  raw_data = FALSE,
  time_period = 2016
)
}

}
