% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_partition.R
\name{data_partition}
\alias{data_partition}
\title{Partition data into a test and a training set}
\usage{
data_partition(data, training_proportion = 0.7, group = NULL, seed = NULL, ...)
}
\arguments{
\item{data}{A data frame, or an object that can be coerced to a data frame.}

\item{training_proportion}{The proportion (between 0 and 1) of the training
set. The remaining part will be used for the test set.}

\item{group}{A character vector indicating the name(s) of the column(s) used
for stratified partitioning.}

\item{seed}{A random number generator seed. Enter an integer (e.g. 123) so
that the random sampling will be the same each time you run the function.}

\item{...}{Other arguments passed to or from other functions.}
}
\value{
A list of two data frames, named \code{test} and \code{training}.
}
\description{
Creates a training and a test set based on a dataframe. Can also be
stratified (i.e., evenly spread a given factor) using the \code{group}
argument.
}
\examples{
df <- iris
df$Smell <- rep(c("Strong", "Light"), 75)

data_partition(df)
data_partition(df, group = "Species")
data_partition(df, group = c("Species", "Smell"))
}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate dataframes: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to rescale and reverse: \code{\link[=data_rescale]{data_rescale()}}, \code{\link[=data_reverse]{data_reverse()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split, cut and merge dataframes: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_cut]{data_cut()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=find_columns]{find_columns()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
