% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_reverse.R
\name{data_reverse}
\alias{data_reverse}
\alias{reverse_scale}
\alias{data_reverse.numeric}
\alias{data_reverse.grouped_df}
\alias{data_reverse.data.frame}
\title{Reverse-Score Variables}
\usage{
data_reverse(x, ...)

reverse_scale(x, ...)

\method{data_reverse}{numeric}(x, range = NULL, verbose = TRUE, ...)

\method{data_reverse}{grouped_df}(x, range = NULL, select = NULL, exclude = NULL, ...)

\method{data_reverse}{data.frame}(x, range = NULL, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A numeric or factor variable.}

\item{...}{Arguments passed to or from other methods.}

\item{range}{Initial (old) range of values. If \code{NULL}, will take the range of
the input vector (\code{range(x)}).}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Character vector of column names. If \code{NULL} (the default), all
variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
A reverse-scored object.
}
\description{
Reverse-score variables (change the keying/scoring direction).
}
\examples{
data_reverse(c(1, 2, 3, 4, 5))
data_reverse(c(-2, -1, 0, 2, 1))

# Specify the "theoretical" range of the input vector
data_reverse(c(1, 3, 4), range = c(0, 4))

# Factor variables
data_reverse(factor(c(1, 2, 3, 4, 5)))
data_reverse(factor(c(1, 2, 3, 4, 5)), range = 0:10)

# Data frames
head(data_reverse(iris))
head(data_reverse(iris, select = "Sepal.Length"))

}
\seealso{
\code{\link[=data_rescale]{data_rescale()}} to change the score range for variables (potentially while reversing),
\code{\link[=normalize]{normalize()}} \code{\link[=standardize]{standardize()}} \code{\link[=ranktransform]{ranktransform()}}

Other transform utilities: 
\code{\link{data_rescale}()},
\code{\link{normalize}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
