% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dv.R
\name{read_dv}
\alias{read_dv}
\title{Read dv}
\usage{
read_dv(destination, as_of = NA, source = "latest")
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{as_of}{the valid date at which you'd like to read the dv}

\item{source}{the source of the dv. Options are 'latest', 'diffs' or 'backup'}
}
\value{
a data frame
}
\description{
Read a version of a versioned dataset into a data frame
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
create_dv(df, temp_dir, backup_count = 5L)

read_dv(temp_dir)

read_dv(temp_dir, source = "backup")

read_dv(temp_dir, as_of = lubridate::now(), source = "diffs")

unlink(temp_dir)

}
