% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_diff_stats.R
\name{get_diff_stats}
\alias{get_diff_stats}
\title{Get diff stats}
\usage{
get_diff_stats(destination)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}
}
\value{
a data frame
}
\description{
Read a versioned dataset's diff statistics to a data frame
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
new_df <- data.frame(a = 2:5, b = letters[2:5])
diff <- diffdfs::diffdfs(new_df, df)
commit_diff(diff, temp_dir)
put_diff_stats(temp_dir)

get_diff_stats(temp_dir)

unlink(temp_dir)

}
