% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_crosswalk.R
\name{crosswalk_variables}
\alias{crosswalk_variables}
\title{Crosswalk \code{dataspice} variables to EML}
\usage{
crosswalk_variables(spice)
}
\arguments{
\item{spice}{(list) Your \code{dataspice} metadata}
}
\value{
(data.frame) A partial EML attributes table
}
\description{
See \code{\link[EML]{set_attributes}} for more information on what must be
filled out after this is run in order to get a valid EML \code{attributeList}.
}
\examples{
\dontrun{
# Load an example dataspice JSON that comes installed with the package
spice <- system.file(
  "examples", "annual-escapement.json",
  package = "dataspice")

# Convert it to EML (notice the warning)
eml_doc <- suppressWarnings({spice_to_eml(spice)})
attributes <- crosswalk_variables(spice)

# Now fill in the attributes data.frame. See `EML::set_attributes`.

# And last, set the attributes on our EML document
eml_doc$dataset$dataTable[[1]]$attributeList <-
  EML::set_attributes(attributes)
}
}
