% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dataset_json.R
\name{read_dataset_json}
\alias{read_dataset_json}
\title{Read a Dataset JSON to datasetjson object}
\usage{
read_dataset_json(file)
}
\arguments{
\item{file}{File path on disk, or a pre-loaded Dataset JSON file in a single element character string}
}
\value{
datasetjson object
}
\description{
This function validated a dataset JSON file on disk against the Dataset JSON schema, and if valid
returns a datasetjson object
}
\examples{
# Read from disk
\dontrun{
  dat <- read_dataset_json("path/to/file.json")
}

# Read from an already imported character vector
ds_json <- dataset_json(iris, "IG.IRIS", "IRIS", "Iris", iris_items)
js <- write_dataset_json(ds_json)
dat <- read_dataset_json(js)
}
