% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rights.R
\name{rights}
\alias{rights}
\alias{rights<-}
\title{Get/set the Rights of the object.}
\usage{
rights(x)

rights(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A semantically rich data frame object created by  \code{dataset::\link{dataset_df}} or
\code{dataset::\link{as_dataset_df}}.}

\item{overwrite}{If the \code{Rights} attribute should be overwritten. In case it
is set to \code{FALSE}, it gives a message with the current \code{Rights}
property instead of overwriting it. Defaults to \code{FALSE}.}

\item{value}{The \code{Rights} as a character set.}
}
\value{
The \code{Rights} attribute as a character of length 1 is added to \code{x}.
}
\description{
Get/set the optional \code{Rights} property as an attribute to an
R object.
}
\details{
\code{Rights} corresponds to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/rights/}{dct:rights} and
\code{\link{datacite}} Rights. Information about rights held in and over the resource.
Typically, rights information includes a statement about various property
rights associated with the resource, including intellectual property rights.
}
\examples{
rights(iris_dataset) <- "CC-BY-SA"
rights(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()}
}
\concept{Reference metadata functions}
