% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{DownloadScoringCode}
\alias{DownloadScoringCode}
\title{Download scoring code JAR}
\usage{
DownloadScoringCode(project, modelId, fileName, sourceCode = FALSE)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{Character string: unique alphanumeric identifier for the model of interest.}

\item{fileName}{Character string: File path where scoring code will be saved.}

\item{sourceCode}{Logical (optional) : Set to True to download source code archive.
It will not be executable.}
}
\description{
Download scoring code JAR
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  DownloadScoringCode(projectId, modelId, "scoringCode.jar")
}
}
