% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImpact.R
\name{GetFeatureImpactForJobId}
\alias{GetFeatureImpactForJobId}
\title{Retrieve completed Feature Impact results given a job ID}
\usage{
GetFeatureImpactForJobId(project, jobId)
}
\arguments{
\item{project}{The project the Feature Impact is part of.}

\item{jobId}{The ID of the job (e.g. as returned from RequestFeatureImpact)}
}
\value{
A data frame with the following columns:
\describe{
  \item{featureName}{The name of the feature}
  \item{impact}{The impact score}
  }
}
\description{
This will wait for the Feature Impact job to be completed (giving an error if the job is not a
Feature Impact job and an error if the job errors).
}
\examples{
\dontrun{
model <- GetAllModels(project)[[1]]
featureImpactJobId <- RequestFeatureImpact(model)
featureImpact <- GetFeatureImpactForJobId(project, featureImpactJobId)
}

}

