% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{RequestPredictions}
\alias{RequestPredictions}
\title{Request predictions from a model against a previously uploaded dataset}
\usage{
RequestPredictions(
  project,
  modelId,
  datasetId,
  includePredictionIntervals = NULL,
  predictionIntervalsSize = NULL
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. The ID of the model to use to make predictions}

\item{datasetId}{numeric. The ID of the dataset to make predictions against (as uploaded from
\code{UploadPredictionDataset})}

\item{includePredictionIntervals}{logical. Optional. Should prediction intervals bounds should be
part of predictions? Only available for time series projects. See "Details" for more
info.}

\item{predictionIntervalsSize}{numeric. Optional. Size of the prediction intervals, in percent.
Only available for time series projects. See "Details" for more info.}
}
\value{
predictJobId to be used by GetPredictions function to retrieve
  the model predictions.
}
\description{
Prediction intervals can now be returned for predictions with datetime models.
Use `includePredictionIntervals = TRUE` in calls to \code{Predict} or \code{RequestPredictions}.
For each model, prediction intervals estimate the range of values DataRobot expects actual values
of the target to fall within. They are similar to a confidence interval of a prediction, but are
based on the residual errors measured during the backtesting for the selected model.
}
\examples{
\dontrun{
  dataset <- UploadPredictionDataset(project, diamonds_small)
  model <- ListModels(project)[[1]]
  modelId <- model$modelId
  predictJobId <- RequestPredictions(project, modelId, dataset$id)
  predictions <- GetPredictions(project, predictJobId)

  # Or, if prediction intervals are desired (datetime only)
  predictJobId <- RequestPredictions(datetimeProject,
                                     DatetimeModelId,
                                     includePredictionIntervals = TRUE,
                                     predictionIntervalsSize = 100)
  predictions <- GetPredictions(datetimeProject, predictJobId, type = "raw")
}
}
