% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatetimeTrendPlots.R
\name{ComputeDatetimeTrendPlots}
\alias{ComputeDatetimeTrendPlots}
\title{Compute datetime trend plots for datetime partitioned model.}
\usage{
ComputeDatetimeTrendPlots(
  model,
  backtest = 0,
  source = SourceType$Validation,
  forecastDistanceStart = NULL,
  forecastDistanceEnd = NULL
)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{backtest}{integer or character. Optional. Compute plots for a specific backtest.
Use the backtest index starting from zero.
To compute plots for holdout, use \code{DataSubset$Holdout}.}

\item{source}{character. Optional. The source of the data for the backtest/holdout.
Must be one of \code{SourceType}.}

\item{forecastDistanceStart}{integer. Optional. The start of forecast distance range
(forecast window) to compute. If not specified, the first forecast distance
for this project will be used. Only for time series supervised models.}

\item{forecastDistanceEnd}{integer. Optional. The end of forecast distance range
(forecast window) to compute. If not specified, the last forecast distance
for this project will be used. Only for time series supervised models.}
}
\value{
An integer value that can be used as the jobId parameter in a subsequent call
  to \code{WaitForJobToComplete}.
}
\description{
Compute datetime trend plots for datetime partitioned model. This includes
Accuracy over Time, Forecast vs Actual, and Anomaly over Time plots.
}
\details{
\itemize{
 \item{
   Forecast distance specifies the number of time steps
   between the predicted point and the origin point.
 }
 \item{
   For the multiseries models only first 1000 series in alphabetical order
   and an average plot for them will be computed.
 }
 \item{
   Maximum 100 forecast distances can be requested for
   calculation in time series supervised projects.
 }
}
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
modelId <- "5996f820af07fc605e81ead4"
model <- GetModel(projectId, modelId)
jobId <- ComputeDatetimeTrendPlots(model)
WaitForJobToComplete(projectId, jobId) # optional step
}
}
