% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{UploadPredictionDataset}
\alias{UploadPredictionDataset}
\title{Function to upload new data to a DataRobot project for predictions}
\usage{
UploadPredictionDataset(
  project,
  dataSource,
  forecastPoint = NULL,
  predictionsStartDate = NULL,
  predictionsEndDate = NULL,
  relaxKIAFeaturesCheck = NULL,
  maxWait = 600
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{dataSource}{object. Either (a) the name of a CSV file (b) a dataframe or
(c) url to publicly available file;
in each case, this parameter identifies the source of the data for which
predictions will be calculated.}

\item{forecastPoint}{character. Optional. The point relative to which predictions will be
generated, based on the forecast window of the project. Only specified in time series
projects.}

\item{predictionsStartDate}{datetime. Optional. Only specified in time series projects.
The start date for bulk predictions. Note that this parameter is for generating
historical predictions using the training data. This parameter should be provided in
conjunction \code{predictionsEndDate}. Can't be provided with \code{forecastPoint}
parameter.}

\item{predictionsEndDate}{datetime. Optional. Only specified in time series projects.
The end date for bulk predictions. Note that this parameter is for generating
historical predictions using the training data. This parameter should be provided
in conjunction \code{predictionsStartDate}. Can't be provided with \code{forecastPoint}
parameter.}

\item{relaxKIAFeaturesCheck}{logical. For time series projects only. If True, missing values
in the known in advance features are allowed in the forecast window at the prediction time.
If omitted or FALSE, missing values are not allowed.}

\item{maxWait}{integer. The maximum time (in seconds) to wait for each of two steps:
(1) The initial dataset upload request, and
(2) data processing that occurs after receiving the response to this initial request.}
}
\value{
list with the following components:
\itemize{
  \item id character. The unique alphanumeric identifier for the dataset.
  \item numColumns numeric. Number of columns in dataset.
  \item name character. Name of dataset file.
  \item created character. time of upload.
  \item projectId character. String giving the unique alphanumeric identifier for the project.
  \item numRows numeric. Number of rows in dataset.
  \item forecastPoint character. The point relative to which predictions will be generated,
    based on the forecast window of the project. Only specified in time series projects,
    otherwise will be NULL.
  \item dataQualityWarnings list. A list of available warnings about potential problems in
    the uploaded prediction dataset. Will be empty if there are no warnings.
}
}
\description{
The DataRobot prediction engine requires a CSV file containing the data to be
used in prediction, and this has been implemented here in two ways.
The first and simpler is to specify dataSource as the name of this CSV file,
but for the convenience of those who wish to work with dataframes, this
function also provides the option of specifying a dataframe, which is then
written to a CSV file and uploaded to the DataRobot server.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  UploadPredictionDataset(projectId, iris)
}
}
