% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfusionChart.R
\name{GetConfusionChart}
\alias{GetConfusionChart}
\title{Retrieve a model's confusion chart for a specified source.}
\usage{
GetConfusionChart(model, source = DataPartition$VALIDATION)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by the function
GetModel, or each element of the list returned by the function ListModels.}

\item{source}{character. The source to pull the confusion chart from. See
\code{DataPartition} for options for sources. Defaults to \code{DataPartition$VALIDATION}.}
}
\value{
data.frame with the following components:
\itemize{
  \item source character. The name of the source of the confusion chart. Will be a member of
    \code{DataPartition}.
  \item data list. The data for the confusion chart, containing:
    \itemize{
      \item classes character. A vector containing the names of all the classes.
      \item confusionMatrix matrix. A matrix showing the actual versus the predicted class
        values.
      \item classMetrics list. A list detailing further metrics for each class:
        \itemize{
          \item wasActualPercentages data.frame. A dataframe detailing the actual percentage
            distribution of the classes.
          \item wasPredictedPercentages data.frame. A dataframe detailing the predicted
            distribution of the classes.
          \item f1 numeric. The F1 score for the predictions of the class.
          \item recall numeric. The recall score for the predictions of the class.
          \item precision numeric. The precision score for the predictions of the class.
          \item actualCount integer. The actual count of values for the class.
          \item predictedCount integer. The predicted count of values for the class.
          \item className character. A vector containing the name of the class.
        }
    }
}
}
\description{
Retrieve a model's confusion chart for a specified source.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetModel(projectId, modelId)
  GetConfusionChart(modelId, source = DataPartition$VALIDATION)
}
}
