% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{subdaily_out_of_range}
\alias{subdaily_out_of_range}
\title{Sub-daily big errors test}
\usage{
subdaily_out_of_range(
  subdailydata,
  meta = NULL,
  outpath,
  time_offset = 0,
  ta_day_upper = 45,
  ta_day_lower = -35,
  ta_night_upper = 40,
  ta_night_lower = -40,
  rr_upper = 100,
  rr_lower = 0,
  w_upper = 50,
  w_lower = 0,
  dd_upper = 360,
  dd_lower = 0,
  sc_upper = 100,
  sc_lower = 0,
  sd_upper = 200,
  sd_lower = 0,
  fs_upper = 100,
  fs_lower = 0
)
}
\arguments{
\item{subdailydata}{A character string giving the path of the input file,
or a 7-column matrix with following columns: variable code, year, month,
day, hour, minute, value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{subdailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{time_offset}{Offset in hours to add to the time to obtain local time.
By default, time_offset = 0.}

\item{ta_day_upper}{is the ta maximum day threshold in degrees Celsius.
By default, ta_day_upper = 45 C.}

\item{ta_day_lower}{is the ta minimum day threshold in degrees Celsius.
By default, ta_day_lower = -35 C.}

\item{ta_night_upper}{is the ta maximum night threshold in degrees Celsius.
By default, ta_night_upper = 40 C.}

\item{ta_night_lower}{is the ta minimum night threshold in degrees Celsius.
By default, ta_night_lower = -40 C.}

\item{rr_upper}{is the rr maximum threshold in millimetres.
By default, rr_upper = 100 mm.}

\item{rr_lower}{is the rr minimum threshold in millimetres.
By default, rr_lower = 0 mm.}

\item{w_upper}{is the w maximum threshold in metres per second.
By default, w_upper = 50 m/s.}

\item{w_lower}{is the w mimumum threshold in metres per second.
By default, w_lower = 0 m/s.}

\item{dd_upper}{is the dd maximum threshold in degrees North.
By default, dd_upper = 360.}

\item{dd_lower}{is the dd minimum threshold in degrees North.
By default, dd_lower = 0.}

\item{sc_upper}{is the sc maximum threshold in percent.
By default, sc_upper = 100\%.}

\item{sc_lower}{is the sc minimum threshold in percent.
By default, sc_lower = 0\%.}

\item{sd_upper}{is the sd maximum threshold in centimetres.
By default, sd_upper = 200 cm.}

\item{sd_lower}{is the sd minimum threshold in centimetres.
By default, sd_lower = 0 cm.}

\item{fs_upper}{is the fs maximum threshold in centimetres.
By default, fs_upper = 100 cm.}

\item{fs_lower}{is the fs minimum threshold in centimetres.
By default, fs_lower = 0 cm.}
}
\description{
Find the subdaily temperature (ta), wind speed (w), 
wind direction (dd), snow cover (sc), snow depth (sd)
and fresh snow (fs) values that exceed thresholds selected by the
user. The output is a list with the days in which ta, rr, dd, w, sc, sd
or fs exceeds some threshold.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).
}
\examples{
subdaily_out_of_range(Rosario$ta, Meta$ta[which(Meta$ta$id=="Rosario"),], 
                      outpath = tempdir(), time_offset = -4.28, 
                      ta_day_upper = 35)

}
\author{
Alba Gilabert, Yuri Brugnara
}
