% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_eval_to_dataquieR_result.R
\name{util_eval_to_dataquieR_result}
\alias{util_eval_to_dataquieR_result}
\title{Evaluate an expression and create a \code{dataquieR_result} object from
it's evaluated value}
\usage{
util_eval_to_dataquieR_result(
  expression,
  env = parent.frame(),
  filter_result_slots,
  nm,
  function_name,
  my_call = expression,
  my_storr_object = NULL,
  init = FALSE,
  called_in_pipeline = TRUE
)
}
\arguments{
\item{expression}{the expression}

\item{env}{the environment to evaluate the expression in}

\item{filter_result_slots}{\link{character} regular expressions, only
if an indicator function's
result's name
matches one of these, it'll
be used for the report. If
of length zero, no filtering
is performed.}

\item{nm}{\link{character} name for the computed result}

\item{function_name}{\link{character} name of the function to be executed}

\item{my_call}{the call being executed (equivalent to \code{expression})}

\item{my_storr_object}{a \code{storr} object to store the result in}

\item{init}{\link{logical} is this an initial call to compute dummy results?}

\item{called_in_pipeline}{\link{logical} if the evaluation should be considered
as part of a pipeline.}
}
\value{
a \code{dataquieR_result} object
}
\description{
if an error occurs, the function will return a corresponding object
representing that error. all conditions will be recorded and replayed,
whenever the result is printed by \link{print.dataquieR_result}.
}
\seealso{
Other reporting_functions: 
\code{\link{util_alias2caption}()},
\code{\link{util_copy_all_deps}()},
\code{\link{util_create_page_file}()},
\code{\link{util_evaluate_calls}()},
\code{\link{util_float_index_menu}()},
\code{\link{util_generate_anchor_link}()},
\code{\link{util_generate_anchor_tag}()},
\code{\link{util_generate_calls}()},
\code{\link{util_generate_calls_for_function}()},
\code{\link{util_load_manual}()},
\code{\link{util_make_data_slot_from_table_slot}()},
\code{\link{util_order_by_order}()},
\code{\link{util_set_size}()}
}
\concept{process}
\concept{reporting_functions}
\keyword{internal}
