% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_summary.R
\name{des_summary}
\alias{des_summary}
\title{Compute Descriptive Statistics}
\usage{
des_summary(
  resp_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2,
  hard_limits_removal = getOption("dataquieR.des_summary_hard_lim_remove",
    dataquieR.des_summary_hard_lim_remove_default),
  ...
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the measurement variable}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{hard_limits_removal}{\link{logical} if TRUE values outside hard limits are
removed from the data before calculating
descriptive statistics. The default is FALSE}

\item{...}{arguments to be passed to all called indicator functions if
applicable.}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryTable}: \link{data.frame}
\item \code{SummaryData}: \link{data.frame}
}
}
\description{
generates a descriptive overview of the variables in \code{resp_vars}.

\link{Descriptor}
}
\details{
TODO
}
\examples{
\dontrun{
prep_load_workbook_like_file("meta_data_v2")
xx <- des_summary(study_data = "study_data", meta_data =
                   prep_get_data_frame("item_level"))
util_html_table(xx$SummaryData)
util_html_table(des_summary(study_data = prep_get_data_frame("study_data"),
                   meta_data = prep_get_data_frame("item_level"))$SummaryData)

}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_des_impl_summary.html}{Online Documentation}
}
