% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_add_writer.R
\name{dp_add_writer}
\alias{dp_add_writer}
\title{Add a writer function for a specific format}
\usage{
dp_add_writer(format, writer)
}
\arguments{
\item{format}{the data format read by the writer Should be a length 1 character vector.}

\item{writer}{the writer function. See details.}
}
\value{
Does not return anything (\code{invisible(NULL)}).
}
\description{
Add a writer function for a specific format
}
\details{
Adds a writer for a given format. The writer is added to a list of writers
referenced by the format. The writer function should accept 'data' with
the data as its first argument, 'resource_name' the name of the resource to
which the data set belongs, 'datapackage' that datapackage to which the data
should be written.

Note that adding a writer for an existing format will overwrite the existing
writer
}
\examples{
# Add a very simple writer for json
json_writer <- function(data, resource_name, datapackage, ...) {
  dataresource <- dp_resource(datapackage, resource_name)
  path <- dp_path(dataresource, full_path = TRUE)
  jsonlite::write_json(data, path)
}

dp_add_writer("json", json_writer)

}
