% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\name{encodeUrlPath}
\alias{encodeUrlPath}
\alias{encodeUrlPath,D1Client-method}
\title{Encode the Input for a URL Path Segment.}
\usage{
encodeUrlPath(x, ...)

\S4method{encodeUrlPath}{D1Client}(x, pathSegment, ...)
}
\arguments{
\item{x}{A D1Client object}

\item{...}{(Not yet used.)}

\item{pathSegment}{: a string to encode}
}
\value{
the encoded form of the input
}
\description{
Encodes the characters of the input so they are not interpreted as reserved
characters in url strings.  Will also encode non-ASCII unicode characters.
}
\examples{
\dontrun{
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
fullyEncodedPath <- paste0("cn/v1/object/", 
    encodeUrlPath(d1c, "doi:10.6085/AA/YBHX00_XXXITBDXMMR01_20040720.50.5"))
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
