% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{methods}
\name{describeObject}
\alias{describeObject}
\alias{describeObject,D1Node-method}
\title{Efficiently get systemmetadata for an object.}
\usage{
describeObject(x, ...)

\S4method{describeObject}{D1Node}(x, pid)
}
\arguments{
\item{x}{The MNode or CNode instance to send request to.}

\item{...}{(Not yet used)}

\item{pid}{Identifier for the object in question. May be either a PID or a SID. Transmitted as
part of the URL path and must be escaped accordingly.}
}
\value{
A list of header elements
}
\description{
This method provides a lighter weight mechanism than getSystemMetadata() for a client to
determine basic properties of the referenced object. This operation requires read privileges for the
object specified by \code{'pid'}, as is granted with a DataONE authentication token or X.509 certificate.
}
\examples{
\dontrun{
library(dataone)
mn_uri <- "https://knb.ecoinformatics.org/knb/d1/mn/v1"
mn <- MNode(mn_uri)
pid <- "knb.473.1"
describeObject(mn, pid)
describeObject(mn, "adfadf") # warning message when wrong pid
}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MNRead.describe}
}
