% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R, R/D1Client.R
\docType{methods}
\name{reserveIdentifier}
\alias{reserveIdentifier}
\alias{reserveIdentifier,CNode-method}
\alias{reserveIdentifier,D1Client-method}
\title{Reserve a identifier that is unique in the DataONE network.}
\usage{
reserveIdentifier(x, ...)

\S4method{reserveIdentifier}{CNode}(x, id)

\S4method{reserveIdentifier}{D1Client}(x, id)
}
\arguments{
\item{x}{The coordinating node to query for its registered Member Nodes}

\item{...}{Additional parameters.}

\item{id}{The identifier that is to be reserved.}
}
\value{
The reserved pid if it was sucessfully reserved, otherwise NULL
}
\description{
The reserveIdentifier method contains the DataONE CN and reserves the specified
identfier that the user has provided. Once a an identifier has been reserved, it and can not be used by any other user.
}
\details{
This method requires a DataONE authentication token or X.509 Certificate. The reservation is made
for the DataONE user identity that created the current authentication token or X.509 certificate.
}
\examples{
\dontrun{
library(dataone)
library(uuid)
cn <- CNode("STAGING")
myId <- sprintf("urn:uuid:\%s", UUIDgenerate())
newId <- reserveIdentifier(cn, myId)
}
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}

