% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDatas.R
\docType{data}
\name{sppAbundance}
\alias{sppAbundance}
\title{Contains information of abundance of plant species in the central-southern
 Andes of Chile.}
\format{
Contains 6 variables, as follows:
\describe{
  \item{sp.name}{name of specie.}
  \item{sp.code.name}{code of specie}
\item{unburned}{Abundance of plants unburned.}
\item{low.sev}{Abundance of plants for low severity of burned.}
\item{mid.sev}{Abundance of plants for middle severity of burned.}
\item{high.sev}{Abundance of plants for high severity of burned.}
 }
}
\source{
The data are provided courtesy of Dr Andres Fuentes-Ramirez at the 
Universidad de La Frontera (Temuco, Chile)
}
\usage{
data(sppAbundance)
}
\description{
Abundance of plant species [50 total] (at parcel scale
 [100 m\eqn{^{2}}{^2}]) in burned Araucaria-Nothofagus 
forests with different levels of fire severity (ie, unburned = unburned, 
low_sev = low severity, 
mid_sev = medium severity , high_sev = high severity) in the China Muerta 
National Reserve, 
Andes of central-southern Chile.
}
\examples{
data(sppAbundance)    
head(sppAbundance) 
}
\references{
- Fuentes-Ramirez A, Salas-Eljatib C, Gonzalez M, Urrutia J, Arroyo P, 
 Santibanez P. 2020. Initial response of understorey vegetation and tree
  regeneration to a mixed-severity fire in old-growth Araucaria-Nothofagus 
  forests. Applied Vegetation Science. 23:210-222.
}
\keyword{datasets}
