% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{diamgr2}
\alias{diamgr2}
\title{Crecimiento diametral de árboles de abeto Noruego (Picea abies) .}
\format{
Los datos contienen las siguientes columnas:
\describe{
\item{sitio}{sitio}	
\item{localidad}{localidad}
\item{arbol}{Numero de árbol}											
\item{edad}{Edad, en años.}
\item{atot}{Altura total, en m.}
\item{dap}{Diametro a la altura del pecho, en cm.}
\item{vtot}{Volumen total, en m\eqn{^{3}}{^3}.}
\item{edap}{Edad a la altura del pecho, en años.}
\item{arbol.id}{Codigo del árbol, que mezcla sitio, localidad y numero del árbol.}
 }
}
\source{
Los datos fueron cedidos por el Prof. Andrew Robinson, durante sus clases de estadistica en
la University of Idaho (USA), mientras el Dr Christian Salas-Eljatib fue un estudiante ahi.
}
\usage{
data(diamgr2)
}
\description{
Datos de crecimiento diametral de von Guttenberg (1915) de árboles de abeto Noruego en los Alpes. 
Los datos contienen mediciones de 107 árboles muestras desde siete localidades que cubrian cinco
 sitios, seleccionados desde rodales de buena sanidad y de densidad completa en los Alpes. Estos datos
son mejor documentados en Zeide (1993).
}
\examples{
data(diamgr2)    
head(diamgr2)
library(lattice)
xyplot(dap ~ edad | arbol.id, type="b", data=diamgr2) 
}
\references{
- von Guttenberg, A. R., 1915. Growth and yield of spruce in Hochgebirge.
   Franz Deuticke, Vienna (in German).
- Zeide, B., 1993. Analysis of growth equations. Forest Science 39 (3), 549-616. \doi{10.1093/forestscience/39.3.594}
}
\keyword{datasets}
