% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{add_labels}
\alias{add_labels}
\title{Add labels}
\usage{
add_labels(p, label.color = "#000", line.width = 1, font.size = 10,
  font.family = "Verdana", ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{label.color}{label color.}

\item{line.width}{width of line.}

\item{font.size}{font size.}

\item{font.family}{font family.}

\item{...}{any other parameter.}
}
\description{
Add data labels.
}
\examples{
states <- data.frame(st = c("AR", "NY", "CA", "IL", "CO", "MT", "TX"),
    val = c(10, 5, 3, 8, 6, 7, 2))

states \%>\%
    datamaps("usa") \%>\%
    add_choropleth(st, val) \%>\%
    add_labels(label.color = "blue")

}
