% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divSpec_condDiv.R
\name{condDiv}
\alias{condDiv}
\title{Conditioning Variable Division}
\usage{
condDiv(vars)
}
\arguments{
\item{vars}{a character string or vector of character strings specifying the variables of the input data across which to divide}
}
\value{
a list to be used for the "by" argument to \code{\link{divide}}
}
\description{
Specify conditioning variable division parameters for data division
}
\details{
Currently each unique combination of values of \code{vars} constitutes a subset.  In the future, specifying shingles for numeric conditioning variables will be implemented.
}
\examples{
d <- divide(iris, by = "Species")
# equivalent:
d <- divide(iris, by = condDiv("Species"))
}
\author{
Ryan Hafen
}
\references{
\itemize{
 \item \url{http://deltarho.org}
 \item \href{http://onlinelibrary.wiley.com/doi/10.1002/sta4.7/full}{Guha, S., Hafen, R., Rounds, J., Xia, J., Li, J., Xi, B., & Cleveland, W. S. (2012). Large complex data: divide and recombine (D&R) with RHIPE. \emph{Stat}, 1(1), 53-67.}
}
}
\seealso{
\code{\link{divide}}, \code{\link{getSplitVars}}, \code{\link{getSplitVar}}
}

