% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_samples.R
\name{check_waterdata_sample_params}
\alias{check_waterdata_sample_params}
\title{Check values from codeservice}
\usage{
check_waterdata_sample_params(service = "characteristicgroup", ...)
}
\arguments{
\item{service}{Options are: "characteristicgroup", "states", "counties",
"countries", "sitetype", "samplemedia", "characteristics", "observedproperty"}

\item{...}{Optional additional query arguments. Only "characteristics" and
"observedproperty" have additional parameters options.}
}
\value{
List, structure depends on service.
}
\description{
Call a service to check on values from:
\url{https://api.waterdata.usgs.gov/samples-data/codeservice/docs}.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
groups <- check_waterdata_sample_params("characteristicgroup")
states <- check_waterdata_sample_params("states")
countries <- check_waterdata_sample_params("countries")
counties <- check_waterdata_sample_params("counties")
sitetypes <- check_waterdata_sample_params("sitetype")
samplemedia <- check_waterdata_sample_params("samplemedia")
characteristics <- check_waterdata_sample_params("characteristics",
                               group = "Biological")
observedProperties <- check_waterdata_sample_params("observedproperty",
                                  text = "phosphorus")
ref_list <- check_waterdata_sample_params("reference-list")
}
\dontshow{\}) # examplesIf}
}
