% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColAs.R
\name{setColAsDate}
\alias{setColAsDate}
\title{Set columns as POSIXct}
\usage{
setColAsDate(dataSet, cols, format = NULL, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{a list of colnames of dataSet (or just one) to transform into dates}

\item{format}{the format of date (function is faster if the format is provided) (default to NULL)}

\item{verbose}{should the function log (logical, default to TRUE)}
}
\value{
dataSet (as a \code{\link{data.table}}), with specified columns set as Date. 
If the transformation generated only NA, the column is set back to its original value.
}
\description{
Set as POSIXct a character column (or a list of columns) from a data.table
}
\details{
setColAsDate is way faster when format is provided. If you want to identify dates and format
automatically, have a look to \code{\link{findAndTransformDates}}
}
\examples{
# Lets build a dataSet set
dataSet <- data.frame(ID = 1:5, 
                  date1 = c("2015-01-01", "2016-01-01", "2015-09-01", "2015-03-01", "2015-01-31"), 
                  date2 = c("2015_01_01", "2016_01_01", "2015_09_01", "2015_03_01", "2015_01_31")
                  )

# Using setColAsDate for date2
data_transformed <- setColAsDate(dataSet,cols = "date2", format = "\%Y_\%m_\%d")

# Control the results
lapply(data_transformed,class)
}
