% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2snapp.r
\name{gl2snapp}
\alias{gl2snapp}
\title{Convert a genlight object to nexus format suitable for phylogenetic analysis by SNAPP (via BEAUti)}
\usage{
gl2snapp(x, outfile = "snapp.nex", outpath = tempdir(), v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{outfile}{-- file name of the output file (including extension).}

\item{outpath}{-- path where to save the output file [default tempdir()]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\description{
The output nexus file contains the snp data and relevant PAUP command lines suitable for BEAUti.
}
\details{
Reference: Bryant, D., Bouckaert, R., Felsenstein, J., Rosenberg, N.A. and RoyChoudhury, A. (2012). Inferring species trees directly from biallelic genetic markers: bypassing gene trees in a full coalescent analysis. Molecular Biology and Evolution 29:1917-1932.
}
\examples{
gl2snapp(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
