% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.hwe.r
\name{gl.report.hwe}
\alias{gl.report.hwe}
\title{Reports departure from Hardy-Weinberg Equilibrium}
\usage{
gl.report.hwe(gl, p = 0.05, subset = "each")
}
\arguments{
\item{gl}{-- a genlight object containing the SNP genotypes [Required]}

\item{p}{-- level of significance (per locus) [Default 0.05]}

\item{subset}{-- list populations to combine in the analysis | each | all [Default "all"]}
}
\value{
a dataframe containing loci, counts of reference SNP homozygotes, heterozygotes
and alternate SNP homozygotes; probability of departure from H-W equilibrium,
and per locus significance with and without Bonferroni Correction.
}
\description{
Calculates the probabilities of agreement with H-W equilibrium based on observed
frequencies of reference homozygotes, heterozygotes and alternate homozygotes. 
Uses the exact calculations contained in function prob.hwe() as developed by
Wigginton, JE, Cutler, DJ, and Abecasis, GR.
}
\details{
#Input is a genlight {adegenet} object containing SNP genotypes (0 homozygous for reference SNP, 
#1 heterozygous, 2 homozygous for alternate SNP).

Tests are applied to all populations pooled (subset="all"), to each population treated separately
(subset="each") or to selected populations (subset=c("pop1","pop2")). Tests for Hwe are
only valid if there is no population substructure, and the tests have sufficient power
only when there is sufficient sample size (n>20).
}
\examples{
list <- gl.report.hwe(testset.gl,0.05, subset=c("EmmacMaclGeor", "EmmacCoopCully"))
list <- gl.report.hwe(testset.gl,0.05, subset="all")
list <- gl.report.hwe(testset.gl,0.05, subset="each")
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
