% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2nhyb.r
\name{gl2nhyb}
\alias{gl2nhyb}
\title{Create an input file for the program NewHybrids}
\usage{
gl2nhyb(gl, outfile = "nhyb.txt", p0 = NULL, p1 = NULL, t = 0,
  m = "random")
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data [required]}

\item{outfile}{-- name of the file to become the input file for NewHybrids [default nhyb.txt]}

\item{p0}{-- list of populations to be regarded as parental population 0 [default NULL]}

\item{p1}{-- list of populations to be regarded as parental population 1 [default NULL]}

\item{t}{-- sets the level at which a gene frequency difference is considered to be fixed [default 0]}

\item{m}{-- specifies the method to use to select 200 loci for NewHybrids [default random]}
}
\value{
The reduced genlight object
}
\description{
This function compares two sets of parental populations to identify loci
that exhibit a fixed difference, returns an genlight object with the reduced data,
and creates an input file for the program NewHybrids using the top 200 loci. In
the absence of two identified parental populations, the script will
select a random set 200 loci only (method=random) or the first 200 loci ranked
on information content (AvgPIC).
}
\details{
A fixed difference occurs when a SNP allele is present in all individuals
of one population and absent in the other. There is provision for setting
a level of tollerance, e.g. t = 0.05 which considers alleles present
at greater than 95% in one population and less than 5% in the other to be
a fixed difference. Only the 200 loci are retained, because of limitations
of NewHybids.

It is important to stringently filter the
data on RepAvg and CallRate if using the random option. One might elect to repeat
the analysis using the random option and combine the resultant posterior probabilites
should 200 loci be considered insufficient.
}
\examples{
\dontrun{
m <- gl2nhyb(gl, c("Pop1", "Pop4"), c("Pop7", "Pop9"), t=0, m="random")
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}

