% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2phylip.r
\name{gl2phylip}
\alias{gl2phylip}
\title{Creates a Phylip input distance matrix from a genlight (SNP) \{adegenet\}
 object}
\usage{
gl2phylip(
  x,
  outfile = "phyinput.txt",
  outpath = tempdir(),
  bstrap = 1,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{outfile}{Name of the file to become the input file for phylip
[default "phyinput.txt"].}

\item{outpath}{Path where to save the output file 
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.'
 when calling this function to direct output files to your working directory.}

\item{bstrap}{Number of bootstrap replicates [default 1].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2, 
progress log; 3, progress and results summary; 5, full report 
[default 2 or as specified using gl.set.verbosity]}
}
\value{
Matrix of Euclidean distances between populations.
}
\description{
This function calculates and returns a matrix of Euclidean distances between 
populations and produces an input file for the phylogenetic program Phylip 
(Joe Felsenstein).
}
\examples{
\donttest{
result <- gl2phylip(testset.gl, outfile='test.txt', bstrap=10)
}

}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Arthur Georges (Post to
 \url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
