% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2plink.r
\name{gl2plink}
\alias{gl2plink}
\title{Converts a genlight object into PLINK format}
\usage{
gl2plink(
  x,
  plink.bin.path = getwd(),
  bed.files = FALSE,
  outfile = "gl_plink",
  outpath = NULL,
  chr.format = "character",
  pos.cM = "0",
  ID.dad = "0",
  ID.mum = "0",
  sex.code = "unknown",
  phen.value = "0",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{plink.bin.path}{Path of PLINK binary file [default getwd()].}

\item{bed.files}{Whether create PLINK files .bed, .bim and .fam
[default FALSE].}

\item{outfile}{File name of the output file [default 'gl_plink'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{chr.format}{Whether chromosome information is stored as 'numeric' or as
'character', see details [default 'character'].}

\item{pos.cM}{A vector, with as many elements as there are loci, containing
the SNP position in morgans or centimorgans [default '0'].}

\item{ID.dad}{A vector, with as many elements as there are individuals,
containing the ID of the father, '0' if father isn't in dataset [default '0'].}

\item{ID.mum}{A vector, with as many elements as there are individuals,
containing the ID of the mother, '0' if mother isn't in dataset [default '0'].}

\item{sex.code}{A vector, with as many elements as there are individuals,
containing the sex code ('male', 'female', 'unknown'). Sex information needs 
just to start with an "F" or "f" for females, with an "M" or "m" for males 
and with a "U", "u" or being empty if the sex is unknown [default 'unknown'].}

\item{phen.value}{A vector, with as many elements as there are individuals,
containing the phenotype value. '1' = control, '2' = case, '0' = unknown
[default '0'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
This function exports a genlight object into PLINK format and save it into a
file.
This function produces the following PLINK files: bed, bim, fam, ped and map.
}
\details{
To create PLINK files .bed, .bim and .fam (bed.files = TRUE), it is necessary
to download the binary file of PLINK 1.9 and provide its path (plink.bin.path).
The binary file can be downloaded from:
\url{https://www.cog-genomics.org/plink/}
After downloading, unzip the file, access the unzipped folder and move the 
binary file ("plink") to your working directory.
If you are using a Mac, you might need to open the binary first to grant 
access to the binary. 
The chromosome of each SNP can be a character or numeric. The chromosome
information for unmapped SNPS is coded as 0.
Family ID is taken from  x$pop.
Within-family ID (cannot be '0') is taken from indNames(x).
Variant identifier is taken from locNames(x).
SNP position is taken from the accessor x$position.
Chromosome name is taken from the accessor x$chromosome
Note that if names of populations or individuals contain spaces, they are 
replaced by an underscore "_".
If you like to use chromosome information when converting to plink format and
 your chromosome names are not from human, you need to change the chromosome 
 names as 'contig1', 'contig2', etc. as described in the section "Nonstandard
  chromosome IDs" in the following link:
  https://www.cog-genomics.org/plink/1.9/input
}
\examples{
\donttest{
require("dartR.data")
test <- platypus.gl
# assigning SNP position
test$position <- test$other$loc.metrics$ChromPos_Platypus_Chrom_NCBIv1
# assigning a dummy name for chromosomes
test$chromosome <- as.factor("1")
gl2plink(test, outpath=tempdir())
}

}
\references{
Purcell, Shaun, et al. 'PLINK: a tool set for whole-genome association and
population-based linkage analyses.' The American journal of human genetics
81.3 (2007): 559-575.
}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Luis Mijangos (Post to
 \url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
