% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateWeightsFunctions.R
\name{generateWeightsUniform}
\alias{generateWeightsUniform}
\title{Generates a weight matrix using \link{runif}}
\usage{
generateWeightsUniform(numUnits1, numUnits2,
  weights.min = getParameter(".weights.min", -0.1, ...),
  weights.max = getParameter(".weights.max", 0.1, ...), ...)
}
\arguments{
\item{numUnits1}{Number of units in the lower layer.}

\item{numUnits2}{Number of units in the upper layer.}

\item{weights.min}{\code{min} parameter to the \link{runif} function.}

\item{weights.max}{\code{max} parameter to the \link{runif} function.}

\item{...}{Additional parameters, used for parameter resolution.}
}
\value{
Weight matrix.
}
\description{
This function is used to generate random weights and biases using
\link{runif}.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, generateWeightsFunction = "generateWeightsUniform",
 weights.min = -.1, weights.max = .5)
}
}
\seealso{
Other weight generation functions: \code{\link{generateWeightsGlorotNormal}},
  \code{\link{generateWeightsGlorotUniform}},
  \code{\link{generateWeightsHeNormal}},
  \code{\link{generateWeightsHeUniform}},
  \code{\link{generateWeightsNormal}}
}

