% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darch.Class.R
\docType{class}
\name{DArch-class}
\alias{DArch-class}
\title{Class for deep architectures}
\description{
This class represents a model created, and/or configured, and/or trained with
the \code{\link{darch}} function.
It implements deep architectures and provides the ability to train 
them with a pre training using contrastive divergence and fine tuning with 
backpropagation, resilient backpropagation and conjugate gradients.
}
\details{
The class inherits all attributes from the class \code{\linkS4class{Net}}.
User-relevant slots include \code{stats} (training statistics), \code{epochs}
(numer of epoch this model was trained for), and \code{parameters} (all
parameters passed to \code{\link{darch}} as well as internal parameters).
}
\section{Slots}{

\describe{
\item{\code{rbmList}}{A list which contains all RBMs for the pre-training.}

\item{\code{layers}}{A list with the layer information. In the first field are the 
weights and in the second field is the unit function.}

\item{\code{cancel}}{Boolean value which indicates if the network training is 
canceled.}

\item{\code{cancelMessage}}{The message when the execution is canceled.}

\item{\code{dropoutMasks}}{List of dropout masks, used internally.}

\item{\code{dataSet}}{\linkS4class{DataSet} instance.}
}}
\author{
Martin Drees
}
\seealso{
\code{\linkS4class{Net}}, \code{\linkS4class{RBM}}

Other darch classes: \code{\link{DataSet-class}},
  \code{\link{Net-class}}, \code{\link{RBM-class}}
}
\keyword{internal}

